<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class List_Doccon extends CI_Controller {

	public function index()
	{
		if($this->session->userdata('logged_in')!="")
		{   
 			$crud = new grocery_CRUD();
                        
			$crud->set_table('mst_doccon');
						$crud->columns('DepCode','DocNo','RevNo','IssueDate','RevisionDate','DocTitle','DocFile');                        
 			$crud->set_relation('DepCode','mst_department','DepartmentName');  
			$crud->display_as('DepCode','Owner of Document')
                             ->display_as('DocNo','Document No.')
			     ->display_as('RevNo','Rev.')                                
                             ->display_as('IssueDate','Issue Date')
                             ->display_as('RevisionDate','Revision Date')                                
			                                 
			     ->display_as('DocFile','Document File')
                             ->display_as('DocType','Doc. Type')                        
                             ->display_as('PMNo','No. of Document')
                             ->display_as('WINo',':::');             
                        
                        $crud->set_subject('Document Control');
                        $crud->required_fields('DepCode','DocType','PMNo');
                        $crud->set_field_upload('DocFile','assets/uploads/files');                        
			
                        if ($this->uri->segment(3) !== FALSE)
                        {
                            $sDepCode=$this->uri->segment(3);
                            if($sDepCode!="ALL")
                            {
                                $crud->where('mst_doccon.DepCode', $sDepCode);
                            }
                        }
                                                                        
                        $crud->order_by('OrderNo');
                        $crud->order_by('DocNo','asc');

                        if($this->session->userdata('stts')!="administrator")
                        {
                            $crud->unset_operations();
                        }
                        
                        $crud->callback_column('DepCode',array($this,'_callback_column_align_center'));
                        $crud->callback_column('RevNo',array($this,'_callback_column_align_center'));
                        $crud->callback_column('IssueDate',array($this,'_callback_column_align_center'));
                        $crud->callback_column('RevisionDate',array($this,'_callback_column_align_center'));
                                    

                        $crud->callback_field('DocNo',array($this,'_callback_field_input_disable'));
                        $crud->callback_field('WINo',array($this,'_callback_field_input_disable'));
                                                
                        $output = $crud->render();
                        
                        $output->judul_title = $this->config->item('nama_title');
                        $output->judul_lengkap = $this->config->item('nama_aplikasi');                    
			$output->credit = $this->config->item('credit_aplikasi');
 			$output->judul_header = "Daftar Dokumen";
                        
			$this->load->view('list/home',$output);
		}
		else
		{
			header('location:'.site_url());
		}
	}
        
        function _callback_column_align_center($value, $row)
        {
                return "<span style=\"width:100%;text-align:center;display:block;\">".$value."</span>";
        }        
        
        function _callback_field_input_disable($value, $primary_key)
        {
                return '<input type="text" value="'.$value.'" name="'.$value.'" disabled>';
        }        
       

}

/* End of file dashboard.php */
/* Location: ./application/controllers/dashboard.php */